﻿// OData, meaning Open Data Protocol, is a protocol for transfer of data over the Internet. 
// Many data providers expose access to their data by publishing an OData web service. 
// You can access data from any OData source in F# using data types that are automatically 
// generated by the type provider. For more information, please go to 
//    http://go.microsoft.com/fwlink/?LinkId=229208

module $safeitemrootname$

#if INTERACTIVE
#r "System.Data.Services.Client"
#r "FSharp.Data.TypeProviders"
#endif

open System.Data.Services.Client
open Microsoft.FSharp.Data.TypeProviders

// Consume demographics population and income OData service from Azure Marketplace. For more information, Please go to https://datamarket.azure.com/dataset/c7154924-7cab-47ac-97fb-7671376ff656
type Demographics = Microsoft.FSharp.Data.TypeProviders.ODataService<ServiceUri = "https://api.datamarket.azure.com/Esri/KeyUSDemographicsTrial/">
let ctx = Demographics.GetDataContext()

//To sign up for a Azure Marketplace account at https://datamarket.azure.com/account/info
ctx.Credentials <- System.Net.NetworkCredential ("<your liveID>", "<your Azure Marketplace Key>")

let cities = query {
    for c in ctx.demog1 do
    where (c.StateName = "Washington")
    } 

for c in cities do
    printfn "%A - %A" c.GeographyId c.PerCapitaIncome2010.Value